<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?ialias=linee-guida-per-luso-del-logo-geecom
    */

    function creaMenuAdmin($geecomDb,$prefissoLink,$ruolo) {
        $impostazioni = recuperaImpostazioni($geecomDb);
        
        echo"<ul class=\"navbar-nav ml-lg-3 mr-auto\">
                <li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."home.php\">Home</a></li>\n";
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."impostazioni.php\">Impostazioni</a></li>\n
                    <li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."statistiche.php\">Statistiche</a></li>\n";
                }
                if($ruolo=="super admin") {
                    echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."gestioneUtenti.php\"> Utenti</a></li>\n";
                }
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."gestioneMenu.php\"> Menu</a></li>\n";
                }

                echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."gestioneContenuti.php?tipo=pagina\">Pagine</a></li>\n";
                echo"<li class=\"dropdown\">
                        <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Blog <b class=\"caret\"></b></a>
                        <div class=\"dropdown-menu\">";
                            if($ruolo=="amministratore" || $ruolo=="super admin") {
                                echo"<a class=\"dropdown-item\" href=\"$prefissoLink"."componenti/blog\">Impostazioni</a>";
                            }
                            echo"<a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneContenuti.php?tipo=articolo\">Articoli</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneCategorie.php\">Categorie</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneTag.php\">Tag</a>    
                        </div>
                    </li>";
                echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."gestioneContenuti.php?tipo=galleria\">Gallerie</a></li>\n
                <li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."gestioneCommenti.php\">Commenti</a></li>\n";
                
                if($ruolo=="amministratore" || $ruolo=="super admin") {                    
                    echo"<li class=\"nav-item dropdown sliding-u-l-r-l\">
                            <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Risorse <b class=\"caret\"></b></a>
                            <div class=\"dropdown-menu\">
                                <a class=\"dropdown-item\" href=\"$prefissoLink"."categorieRisorse.php\">Categorie</a>
                                <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneRisorse.php\">File</a>
                            </div>
                        </li>";
                }
                
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    $queryComponente = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Annunci'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/annunci\">Annunci</a></li>\n";
                    }
                    
                    $queryComponente = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Ecommerce'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/ecommerce\">Ecommerce</a></li>\n";
                    }

                    $queryComponente = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Marketplace'";
                    $risComponente   = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risComponente->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/marketplace\">Marketplace</a></li>\n";
                    }
                    
                    $queryComponente = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Hotel manager'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/hotelManager\">Hotel manager</a></li>\n";
                    }
                    
                    $queryComponente = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Eventi'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/eventi\">Eventi</a></li>\n";
                    }
                    
                    $queryComponente = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Quero'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/quero\">Quero</a></li>\n";
                    }
                    
                    echo"<li class=\"nav-item\"><a href=\"#\" data-toggle=\"modal\" data-target=\"#menu-componenti\" class=\"nav-link\" data-toggle=\"dropdown\">Componenti</a></li>";
                }
                
                if($ruolo=="super admin") {
                    echo"<li class=\"nav-item dropdown sliding-u-l-r-l\">
                      <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Strumenti <b class=\"caret\"></b></a>
                        <div class=\"dropdown-menu\">
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/backup\">Backup</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/importaEsporta\">Importa / esporta</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/informazioniSistema\">Informazioni di sistema</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/storicoOperazioni\">Storico operazioni</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/testMail\">Test email</a>
                        </div>
                    </li>";
                }
        echo"</ul>";
    }
    
   /* 
    *  stampa il menu principale nelle pagine visibili a tutti. Prende in input il database su cui fare la ricerca
    *  e le classi css definite nella costante "allineamentoMenuPrincipale" definita nel file stile.php (questo consente,
    *  tra le altre cose, di stabilire l'allineamento del menu)
    *  
    * la variabile $menuBarraSuperiore indica se il menu viene eseguito nella barra superiore e deve essere impostata a true solo
    * in questo caso. Viene passata alla funzione che si occupa di stampare le singole voci menu
    */
    function creaMenu($geecomDb, $lingua, $personalizzazioniMenu,$idMenu=0,$tipoMenu="menuPrincipale",$menuBarraSuperiore=false) {
        $impostazioni = recuperaImpostazioni($geecomDb);
        $classeMenu = $personalizzazioniMenu["classeMenu"];
        
        if($idMenu==0) {
            $impostazioniLingua = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
            $tipoMenu = "menu".ucfirst($lingua);
            $idMenu = $impostazioniLingua[$tipoMenu];
            $queryMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu={$impostazioniLingua[$tipoMenu]} AND tipo NOT LIKE 'voce sottoMenu' AND tipo NOT LIKE 'colonna megamenu' AND tipo NOT LIKE 'sottovoce megamenu' ORDER BY posizione ASC";
        }
        else {
            $queryMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu={$idMenu} AND tipo NOT LIKE 'voce sottoMenu' AND tipo NOT LIKE 'colonna megamenu' AND tipo NOT LIKE 'sottovoce megamenu' ORDER BY posizione ASC";
        }
        $risVociMenu = $geecomDb->eseguiQueryLettura($queryMenu);

        if($risVociMenu->num_rows>0) {
            // prendo le informazioni del menu
            $menu = $geecomDb->leggiSingolaRiga("geecB_menu",$idMenu);

            echo"<ul class=\"$classeMenu\">";
            while($voceMenu = $risVociMenu->fetch_assoc()) {
                stampaSingolaVoceDiMenu($geecomDb,$impostazioni,$voceMenu,$menu,$idMenu,$personalizzazioniMenu,$tipoMenu,$menuBarraSuperiore);
            }
            echo"</ul>";
            if($menu["formRicerca"]=="si" && $personalizzazioniMenu["tipoRicerca"]=="modal") {
                echo"<a class=\"btn btn-cerca\" href=\"#ricercaFullScreen\"><i class=\"fas fa-search\"></i></a>";
            }
            else if($menu["formRicerca"]=="si" && $personalizzazioniMenu["tipoRicerca"]=="inline") {
                echo"<div class=\"ricerca-inline\">
                        <form name=\"ricercaInline\" action=\"cerca.php\">
                            <input type=\"text\" class=\"d-none\" name=\"tipoRicerca\" value=\"ricerca\">
                            <input type=\"text\" class=\"form-control rounded-0\" name=\"chiaveRicerca\" placeholder=\"Cerca\" aria-label=\"Cerca\" aria-describedby=\"Cerca\">
                            <button class=\"btn rounded-0\" type=\"submit\" onclick=\"document.ricercaInline.submit()\"><i class=\"fas fa-search\"></i></button>
                        </form>
                    </div>";
            }
        }
    }
    
   /* 
    * stampa il menu principale nelle pagine visibili a tutti, con il logo al centro. Si comporta come creaMenu()
    * prende in input gli stessi dati più la variabile contenente le impostazioni e quella contenente la configurazioneAspetto
    * selezionata
    */
    function creaMenuConLogoAlCentro($geecomDb, $lingua, $personalizzazioniMenu,$impostazioni,$configurazioneAspetto,$idMenu=0) {
        $impostazioni = recuperaImpostazioni($geecomDb);
        $classeMenu = $personalizzazioniMenu["classeMenu"];
        
        if($idMenu==0) {
            $impostazioniLingua = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
            $tipoMenu = "menu".ucfirst($lingua);
            $idMenu = $impostazioniLingua[$tipoMenu];
            $queryMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu={$impostazioniLingua[$tipoMenu]} AND tipo NOT LIKE 'voce sottoMenu' AND tipo NOT LIKE 'colonna megamenu' AND tipo NOT LIKE 'sottovoce megamenu' ORDER BY posizione ASC";
            $risVociMenu = $geecomDb->eseguiQueryLettura($queryMenu);
        }
        else {
            $queryMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu={$idMenu} AND tipo NOT LIKE 'voce sottoMenu' ORDER BY posizione ASC";
            $risVociMenu = $geecomDb->eseguiQueryLettura($queryMenu);
        }
        
        $numeroVociMenu = $risVociMenu->num_rows;
        $metaVoci = ceil($numeroVociMenu/2);
        
        // prendo le informazioni del menu
        $menu = $geecomDb->leggiSingolaRiga("geecB_menu",$idMenu);
        $contatoreVoci = 0;
        
        echo"<ul class=\"$classeMenu\">";
        while($voceMenu = $risVociMenu->fetch_assoc()) {
            stampaSingolaVoceDiMenu($geecomDb,$impostazioni,$voceMenu,$menu,$idMenu,$personalizzazioniMenu);
            $contatoreVoci++;
            if($contatoreVoci==$metaVoci) {
                echo"<li class=\"nav-item col\"><a class=\"navbar-brand mx-4 d-none d-lg-inline-block\" href=\"{$impostazioni["urlSito"]}\"><img class=\"img-fluid\" src=\"{$impostazioni["urlSito"]}/{$configurazioneAspetto["logo"]}\"></a></li>";
            }
        }
        echo"</ul>";
        if($menu["formRicerca"]=="si" && $personalizzazioniMenu["tipoRicerca"]=="modal") {
            echo"<a class=\"btn btn-cerca\" href=\"#ricercaFullScreen\"><i class=\"fas fa-search\"></i></a>";
        }
        else if($menu["formRicerca"]=="si" && $personalizzazioniMenu["tipoRicerca"]=="inline") {
            echo"<div class=\"ricerca-inline\">
                    <form name=\"ricercaInline\" action=\"cerca.php\">
                        <input type=\"text\" class=\"d-none\" name=\"tipoRicerca\" value=\"ricerca\">
                        <input type=\"text\" class=\"form-control rounded-0\" name=\"chiaveRicerca\" placeholder=\"Cerca\" aria-label=\"Cerca\" aria-describedby=\"Cerca\">
                        <button class=\"btn rounded-0\" type=\"submit\" onclick=\"document.ricercaInline.submit()\"><i class=\"fas fa-search\"></i></button>
                    </form>
                </div>";
        }
    }
    
    /* 
    *  stampa il menu secondario nella barra superiore. Prende in input il database su cui fare la ricerca,
    *  l'id del menu e le classi css per dare un aspetto diverso al menu. 
    */ 
    function creaMenuSecondario($geecomDb, $classeCss,$idMenu) {
        $queryMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu=$idMenu AND tipo NOT LIKE 'voce sottoMenu' ORDER BY posizione ASC";
        $risVociMenu = $geecomDb->eseguiQueryLettura($queryMenu);

        echo"<div class=\"list-group\" >";
        while($voceMenu = $risVociMenu->fetch_assoc()) {
            if($voceMenu["tipo"]=="menu a tendina") { //se si tratta di un menu a tendina va a cercare tutte le voci che deve contenere
                echo"<li class=\"dropdown\">
                <a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">{$voceMenu["nome"]} <b class=\"caret\"></b></a>";
                $querySottoMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'voce sottoMenu' AND tagSottoMenu='{$voceMenu["tagSottoMenu"]}' ORDER BY posizione ASC";
                $risSottoMenu = $geecomDb->eseguiQueryLettura($querySottoMenu);
                echo"<ul class=\"dropdown-menu\">";
                while($sottoMenu = $risSottoMenu->fetch_assoc()) { 
                    echo"<li><a href=\"{$sottoMenu["link"]}\">{$sottoMenu["nome"]}</a></li>";
                }
                echo"</ul>";
                echo"</li>";
            }
            else { 
                echo"<a href=\"{$voceMenu["link"]}\" class=\"list-group-item\" >{$voceMenu["nome"]}</a>";
            }
        }
        echo"</div>";
    }

    /*
     * Funzione utilizzata da creaMenu() e creaMenuDiviso() per stampare le singole voci di menu
     * 
     * la variabile $menuBarraSuperiore indica se il menu viene eseguito nella barra superiore. In questo caso la gestione del menu a tendina deve
     * essere la stessa degli aspetti con menu a vista, anche quando l'aspetto selezionato ha un menu a colonna
     */
    function stampaSingolaVoceDiMenu($geecomDb,$impostazioni,$voceMenu,$menu,$idMenu,$personalizzazioniMenu,$tipoMenu="menuPrincipale",$menuBarraSuperiore=false) {
        $paginaCorrente = $_SERVER["REQUEST_URI"];
        $urlCompleto    = $_SERVER["HTTP_HOST"].$paginaCorrente;
        $classeElementoMenu = $personalizzazioniMenu["elementoMenu"];
        $linkMenu = $personalizzazioniMenu["linkMenu"];
        $classeElementoSottoMenu = $personalizzazioniMenu["elementoSottomenu"];
        
        $classiAggiuntiveDivDropdown = ($tipoMenu=="menuPrincipale") ? "": "dropdown-menu-right";
        $stringaIcona = ($voceMenu["icona"]!="") ? "<i class=\"{$voceMenu["icona"]}\"></i> " : "";
        if($voceMenu["tipo"]=="menu a tendina" && (($menuBarraSuperiore==true) || ($impostazioni["aspettoSito"]=="classico" || $impostazioni["aspettoSito"]=="menuBoxato" || $impostazioni["aspettoSito"]=="logoSinistraMenuCentrato" || $impostazioni["aspettoSito"]=="menuCentrato" || $impostazioni["aspettoSito"]=="logoCentrale" || $impostazioni["aspettoSito"]=="menuSuDueLivelli" || $tipoMenu=="menuSecondario"))) { //se si tratta di un menu a tendina va a cercare tutte le voci che deve contenere
            echo"<li class=\"nav-item dropdown $classeElementoMenu \">
            <a class=\"nav-link dropdown-toggle\" href=\"#menuATendina{$voceMenu["id"]}\" aria-haspopup=\"true\" data-toggle=\"dropdown\" aria-expanded=\"false\">$stringaIcona {$voceMenu["nome"]}</a>";
            $querySottoMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'voce sottoMenu' AND vocePadre='{$voceMenu["id"]}' ORDER BY posizione ASC";
            $risSottoMenu = $geecomDb->eseguiQueryLettura($querySottoMenu);
            echo"<div class=\"dropdown-menu $classiAggiuntiveDivDropdown\" id=\"menuATendina{$voceMenu["id"]}\">";
            while($sottoMenu = $risSottoMenu->fetch_assoc()) {
                $stringaIcona = ($sottoMenu["icona"]!="") ? "<i class=\"{$sottoMenu["icona"]}\"></i> " : "";
                echo"<a class=\"$classeElementoSottoMenu\" href=\"{$sottoMenu["link"]}\">$stringaIcona {$sottoMenu["nome"]}</a>";
            }
            echo"</div>";
            echo"</li>";
        }
        else if($voceMenu["tipo"]=="menu a tendina") { //se si tratta di un menu a tendina dei template con colonna laterale esegue quest'altro codice
                    
            echo"<li class=\"nav-item dropdown $classeElementoMenu \">
            <a class=\"collapsed\" href=\"#menuATendina{$voceMenu["id"]}\" data-toggle=\"collapse\" aria-expanded=\"false\">$stringaIcona {$voceMenu["nome"]} <i class=\"fas rotate fa-pull-right text-muted fa-angle-down\"></i></a>";
            $querySottoMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'voce sottoMenu' AND vocePadre='{$voceMenu["id"]}' ORDER BY posizione ASC";
            $risSottoMenu = $geecomDb->eseguiQueryLettura($querySottoMenu);
            echo"<ul id=\"menuATendina{$voceMenu["id"]}\" class=\"list-unstyled collapse\">";
            while($sottoMenu = $risSottoMenu->fetch_assoc()) {
                $stringaIcona = ($sottoMenu["icona"]!="") ? "<i class=\"{$sottoMenu["icona"]}\"></i> " : "";
                echo"<li><a class=\"$classeElementoSottoMenu\" href=\"{$sottoMenu["link"]}\">$stringaIcona {$sottoMenu["nome"]}</a></li>";
            }
            echo"</ul>";
            echo"</li>";
        }
        else if($voceMenu["tipo"]=="linkCarrello") {
            if(isset($_SESSION["carrello"])) {
                $numeroProdotti  = $geecomDb->contaRigheTabella("geecEc_prodottiOrdinati",array("idCarrello"=>$_SESSION["carrello"]));
                $ordiniSito      = $geecomDb->contaRigheTabella("geecEc_ordini",array("idCarrello"=>$_SESSION["carrello"]));
                $stringaProdotti = ($ordiniSito>0) ?  "<span id=\"labelNumeroCarrello\" class=\"badge badge-pill badge-primary\">0</span>" : "<span id=\"labelNumeroCarrello\" class=\"badge badge-pill badge-primary\">$numeroProdotti</span>";
            }
            else {
                $stringaProdotti = "<span id=\"labelNumeroCarrello\" class=\"badge badge-pill badge-primary\">0</span>";
            }
            echo"<li class=\"$classeElementoMenu\"><a class=\"$linkMenu\" href=\"{$voceMenu["link"]}\">$stringaIcona {$voceMenu["nome"]} $stringaProdotti</a></li>";
        }
        else if($voceMenu["tipo"]=="linkGeecomAdmin") {
            $stringaIcona = ($voceMenu["icona"]!="") ? "<i class=\"{$voceMenu["icona"]}\"></i> " : "";
            if(isset($_SESSION["geecomUser_id"])) {
                echo"<li class=\"nav-item dropdown $classeElementoMenu \">
                        <a class=\"btn btn-link px-0 pl-sm-3 dropdown-toggle\" href=\"#\" role=\"button\" id=\"dropdownMenuLink\" data-toggle=\"dropdown\" aria-haspopup=\"true\" aria-expanded=\"false\">
                            Ciao {$_SESSION["geecomUser_nome"]}
                        </a>
                        <div class=\"dropdown-menu dropdown-menu-right\" aria-labelledby=\"dropdownMenuLink\">
                            <a class=\"$classeElementoSottoMenu\" href=\"areariservata/index.php?alias=profilo\"><i class=\"fas fa-bullhorn mr-2\"></i>Profilo</a>
                            <a class=\"$classeElementoSottoMenu\" href=\"areariservata/utenti/logout.php\"> <i class=\"fa fa-sign-out-alt mr-2\"></i>Esci</a>
                        </div>
                    </li>";
            }
            else {
                echo"<li class=\"$classeElementoMenu\"><a class=\"$linkMenu\" href=\"{$voceMenu["link"]}\">$stringaIcona {$voceMenu["nome"]}</a></li>";
            }
        }
        else if($voceMenu["tipo"]=="mega menu") {
            echo"<li class=\"nav-item dropdown has-megamenu $classeElementoMenu \">
                    <a class=\"nav-link dropdown-toggle\" href=\"#\" data-toggle=\"dropdown\">$stringaIcona {$voceMenu["nome"]}</a>
                    <div class=\"dropdown-menu megamenu\">
                        <div class=\"row\">";
                            if($voceMenu["testoAssociato"]!="") {
                                echo"<div class=\"col-12\">
                                    <div class=\"px-3\">
                                        {$voceMenu["testoAssociato"]}
                                    </div>
                                    <hr>
                                </div>";
                            }
                            $query       = "SELECT * FROM geecB_vociMenu WHERE tipo LIKE 'colonna megamenu' AND vocePadre={$voceMenu["id"]} ORDER BY posizione ASC";
                            $risMenuCollegati = $geecomDb->eseguiQueryLettura($query);
                            $classeDivMenuCollegati = ($risMenuCollegati->num_rows>=4) ? "col-md-3" : "col-md-4";
                            while($colonnaMegaMenu = $risMenuCollegati->fetch_assoc()) {

                                $query       = "SELECT * FROM geecB_vociMenu WHERE tipo LIKE 'sottovoce megamenu' AND vocePadre={$colonnaMegaMenu["id"]} ORDER BY posizione ASC";
                                $risVociMenuCollegato = $geecomDb->eseguiQueryLettura($query);
                                echo"<div class=\"$classeDivMenuCollegati\">";
                                if($voceMenu["mostraNomiColonne"]=="si") {
                                    $stringaIcona = ($colonnaMegaMenu["icona"]!="") ? "<i class=\"{$colonnaMegaMenu["icona"]}\"></i> " : "";
                                    echo"<h6 class=\"mx-3\">$stringaIcona {$colonnaMegaMenu["nome"]}</h6>";
                                }
                                while($voceMenuCollegato = $risVociMenuCollegato->fetch_assoc()) {
                                    $stringaIcona = ($voceMenuCollegato["icona"]!="") ? "<i class=\"{$voceMenuCollegato["icona"]}\"></i> " : "";
                                    echo"<a class=\"dropdown-item\" href=\"{$voceMenuCollegato["link"]}\">$stringaIcona {$voceMenuCollegato["nome"]}</a>";
                                }
                                echo"</div>";
                            }
                    echo"</div>
                    </div>
                </li>";
        }
        else if($voceMenu["tipo"]=="link immagine") {
            echo"<li ><a href=\"{$voceMenu["link"]}\"><img src=\"{$voceMenu["immagine"]}\"></a></li>";
        }
        else { // link personalizzato oppure link contenuto
            if(strpos($paginaCorrente,$voceMenu["link"])>0 || $urlCompleto==$voceMenu["link"]) {
                echo"<li class=\"$classeElementoMenu active\"><a class=\"$linkMenu\" href=\"{$voceMenu["link"]}\">$stringaIcona {$voceMenu["nome"]}</a></li>";
            }
            else {
                echo"<li class=\"$classeElementoMenu\"><a class=\"$linkMenu\" href=\"{$voceMenu["link"]}\">$stringaIcona {$voceMenu["nome"]}</a></li>";
            }
        }
    }

    /*
     * funzione utilizzata nella barra superiore per trovare il contenuto tradotto
     */
    function linkContenutoTradotto($geecomDb, $impostazioni, $contenuto, $lingua) {
        $impostazioniLingue = recuperaImpostazioniLingue($geecomDb);
        if($contenuto["linguaContenuto"]=="$lingua") {
            return "#";
        }
        else {
            if($impostazioniLingue["linguaPrincipale"]!=$lingua) { // se si sta traducendo qualcosa dalla lingua principale del sito
                $contenutoPrincipale = ($contenuto["linguaContenuto"]==$impostazioniLingue["linguaPrincipale"]) ? $contenuto : $geecomDb->leggiSingolaRiga("geecB_contenuti",$contenuto["contenutoRiferimento"]);
                $query               = "SELECT * FROM geecB_contenuti WHERE contenutoRiferimento = {$contenutoPrincipale["id"]} AND linguaContenuto LIKE '$lingua' LIMIT 1";
            }
            else {
                $query = "SELECT * FROM geecB_contenuti WHERE id = {$contenuto["contenutoRiferimento"]} LIMIT 1";
            }
            $risTraduzione = $geecomDb->eseguiQueryLettura($query);
            if($risTraduzione->num_rows>0) {
                $paginaTradotta = $risTraduzione->fetch_assoc();
                $link = GeneratoreUrl::creaUrlContenuto($paginaTradotta, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
            else { //se non c'è rimanda all'home page della lingua scelta
                $homeEn = $geecomDb->leggiSingolaRiga("geecB_contenuti",$impostazioni["homePageEn"]);
                $link = GeneratoreUrl::creaUrlContenuto($homeEn, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
        }
    }
    
    /*
     * funzione utilizzata nella barra superiore per trovare la traduzione di un elemento
     * del portfolio
     */
    function linkElementoPorfolioTradotto($geecomDb,$impostazioni,$contenuto, $lingua) {
        $datiPortfolio = $geecomDb->leggiSingolaRiga("geec_portfolio",$contenuto["contenutoRiferimento"]);
        
        $colonna       = "traduzione".ucfirst($lingua);
        if($datiPortfolio[$colonna]==-1) {
            return $impostazioni["urlSito"];
        }
        else if($datiPortfolio[$colonna]==0) {
            return GeneratoreUrl::creaUrlContenuto($contenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
        }
        else {
            $queryEelementoPortfolioTradotto = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento={$datiPortfolio[$colonna]} AND posizione={$contenuto["posizione"]}";
            $risElementoPortfolioTradotto    = $geecomDb->eseguiQueryLettura($queryEelementoPortfolioTradotto);
            if($risElementoPortfolioTradotto->num_rows > 0) {
                $elementoTradotto = $risElementoPortfolioTradotto->fetch_assoc();
                return GeneratoreUrl::creaUrlContenuto($elementoTradotto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
            }
        }
    }
    
    /*
     * funzione utilizzata nella barra superiore per trovare la traduzione di una categoria
     */
    function linkCategoriaTradotta($geecomDb, $impostazioni, $categoria, $lingua) {
        $impostazioniLingue = recuperaImpostazioniLingue($geecomDb);
        if($categoria["lingua"]=="$lingua") {
            return "#";
        }
        else {
            if($impostazioniLingue["linguaPrincipale"]!=$lingua) { // se si sta traducendo qualcosa dalla lingua principale del sito
                $contenutoPrincipale = ($categoria["lingua"]==$impostazioniLingue["linguaPrincipale"]) ? $categoria : $geecomDb->leggiSingolaRiga("geec_categorie",$categoria["categoriaRiferimento"]);
                $query               = "SELECT * FROM geec_categorie WHERE categoriaRiferimento = {$contenutoPrincipale["id"]} AND lingua LIKE '$lingua' LIMIT 1";
            }
            else {
                $query = "SELECT * FROM geec_categorie WHERE id = {$categoria["categoriaRiferimento"]} LIMIT 1";
            }
            $risTraduzione = $geecomDb->eseguiQueryLettura($query);
            if($risTraduzione->num_rows>0) {
                $paginaTradotta = $risTraduzione->fetch_assoc();
                $link = GeneratoreUrl::creaUrlCategoria($paginaTradotta, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
            else { //se non c'è rimanda all'home page della lingua scelta
                $homeEn = $geecomDb->leggiSingolaRiga("geec_categorie",$impostazioni["homePageEn"]);
                $link = GeneratoreUrl::creaUrlContenuto($homeEn, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
        }
    }
    
    /*
     * funzione utilizzata nella barra superiore per trovare il prodotto tradotto
     */
    function linkProdottoTradotto($geecomDb, $impostazioni, $prodotto, $lingua) {
        $impostazioniLingue = recuperaImpostazioniLingue($geecomDb);
        if($prodotto["lingua"]=="$lingua") {
            return "#";
        }
        else {
            if($impostazioniLingue["linguaPrincipale"]!=$lingua) { // se si sta traducendo qualcosa dalla lingua principale del sito
                $prodottoPrincipale = ($prodotto["lingua"]==$impostazioniLingue["linguaPrincipale"]) ? $prodotto : $geecomDb->leggiSingolaRiga("geecEc_prodotti",$prodotto["prodottoRiferimento"]);
                $query               = "SELECT * FROM geecEc_prodotti WHERE prodottoRiferimento = {$prodottoPrincipale["id"]} AND lingua LIKE '$lingua' LIMIT 1";
            }
            else {
                $query = "SELECT * FROM geecEc_prodotti WHERE id = {$prodotto["prodottoRiferimento"]} LIMIT 1";
            }
            $risTraduzione = $geecomDb->eseguiQueryLettura($query);
            if($risTraduzione->num_rows>0) {
                $prodottoTradotto = $risTraduzione->fetch_assoc();
                $link = GeneratoreUrl::creaUrlProdotto($prodottoTradotto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
            else { //se non c'è rimanda all'home page della lingua scelta
                $homeEn = $geecomDb->leggiSingolaRiga("geecB_contenuti",$impostazioni["homePageEn"]);
                $link = GeneratoreUrl::creaUrlContenuto($homeEn, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
        }
    }
    
    // questa funzione stampa i collegamenti agli altri prodotti geecom presenti nello spazio web
    // se il prodotto corrispondente non è installato stampa un 'immagine grigia
    // prende in input il nome del prodotto corrente, prelevato dal file costanti.php
    // il campo prefisso contiene eventuali percorsi da aggiungere ai link e alle immagini, deve essere vuoto per le pagine principali
    // e contenere il valore ../../ per i componenti
    function stampaProdotti($geecomDb, $nomeProdotto,$prefisso) {
        $queryProdotti = "SELECT * FROM geec_prodotti";
        $risProdotti = $geecomDb->eseguiQueryLettura($queryProdotti);

        echo"<ul class=\"navbar-nav ml-auto\">";
        while($prodotto = $risProdotti->fetch_assoc()) {

            //questo controllo serve per sapere se il prodotto è quello che si sta usando, in tal caso il link sarà un #
            if($prodotto["nome"]==$nomeProdotto) {
                $linkProdotto = "#";
                $title        = "Geecom ".$prodotto["nome"]." (in uso)";
                $classeLink   = "active";
            }
            else {
                // recupero le impostazioni del prodotto
                if($prodotto["nome"]=="CMS" && $prodotto["installato"]=="si") {
                    $impostazioni = $geecomDb->leggiSingolaRiga("geecB_impostazioni",1);
                }
                else if($prodotto["nome"]=="Admin" && $prodotto["installato"]=="si") {
                    $impostazioni = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
                }
                else if($prodotto["nome"]=="Doc" && $prodotto["installato"]=="si"){
                    $impostazioni = $geecomDb->leggiSingolaRiga("geecD_impostazioni",1);
                }
                else {
                    $impostazioni = array();
                }
                
                $linkProdotto = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni, $prodotto);
                $title        = "passa a Geecom ".$prodotto["nome"];
                $classeLink   = "";
            }
            
            if($prodotto["installato"]=="si") {
                echo"<li class=\"nav-item\">
                    <a  class=\"$classeLink\" href=\"$linkProdotto\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"$title\"><img  src=\"$prefisso"."../template/img/icona_Geecom_{$prodotto["nome"]}.svg\" ></a>
                </li>";
            }
            else {
                echo"<li class=\"nav-item\">
                    <a class=\"disable\" href=\"#\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"Geecom {$prodotto["nome"]} non installato\"><img src=\"$prefisso"."../template/img/icona_Geecom_{$prodotto["nome"]}.svg\" class=\"inattivo\"></a>
                </li>";
            }
        }
        echo"</ul>";
    }

    /*
     * funzione che viene usata nella barra superiore del sito
     */
    function percorsoImmagineBandiera($lingua) {
        if($lingua=="italiano") {
            return "template/img/bandiere/italia.svg";
        }
        else if($lingua=="inglese") {
            return "template/img/bandiere/regno-unito.svg";
        }
        else if($lingua=="tedesco") {
            return "template/img/bandiere/germania.svg";
        }
        else if($lingua=="francese") {
            return "template/img/bandiere/francia.svg";
        }
        else if($lingua=="spagnolo") {
            return "template/img/bandiere/spagna.svg";
        }
        else {
            return "";
        }
    }

    //funzione cre restituisce le impostazioni delle lingue
    //è chiamata da tutte le pagine di front end e da index.php di amministrazione
    function recuperaImpostazioniLingue($geecomDb) {
        $queryImpostazioniLingue = "SELECT * FROM geecB_impostazioniLingue WHERE id=1";
        $risImpostazioniLingue = $geecomDb->eseguiQueryLettura($queryImpostazioniLingue);
        $impostazioniLingue = $risImpostazioniLingue->fetch_assoc();
        return $impostazioniLingue;
    }
    
    //funzione cre restituisce le impostazioni di inclusioni globali
    //è chiamata da tutte le pagine di front end e da index.php di amministrazione
    function recuperaInclusioni($geecomDb) {
        $queryInclusioni = "SELECT * FROM geecB_inclusioni WHERE id=1";
        $risInclusioni   = $geecomDb->eseguiQueryLettura($queryInclusioni);
        $inclusioni = $risInclusioni->fetch_assoc();
        return $inclusioni;
    }

    function eseguiAnalisiSeo($contenuto) {
        //variabili che memorizzano l'indicatore per la seo
        $seoPositivo = "<span id=valoreSeo class=\"label label-success\">buona</span>";
        $seoDiscreto = "<span id=valoreSeo class=\"label label-warning\">discreta</span>";
        $seoNegativo = "<span id=valoreSeo class=\"label label-danger\">scadente</span>";
        
        $seoPositivoTesto = "buona";
        $seoDiscretoTesto = "discreta";
        $seoNegativoTesto = "scadente";
        $punteggioSeo = 0;

        //inizializzazione array che contiene i risultati
        $analisiSeo = array();
        $analisiSeo["esito"] = $seoNegativo;
        $analisiSeo["esitoTesto"] = $seoNegativoTesto;
        
        $suggerimenti = array();
        
        //analisi titolo
        $numeroCaratteriTitolo = strlen($contenuto["titolo"]);
        if($numeroCaratteriTitolo > 0 && $numeroCaratteriTitolo < 20) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>titolo</strong> è troppo corto, solo $numeroCaratteriTitolo caratteri. Il dato ottimale è tra i 50 e i 70 caratteri.</p>";
        }
        else if ($numeroCaratteriTitolo > 20 && $numeroCaratteriTitolo < 50) {
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriTitolo>70) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>titolo</strong> è troppo lungo, $numeroCaratteriTitolo caratteri. Il dato ottimale è tra i 50 e i 70 caratteri.</p>";
        }
        
        //analisi meta descrizione
        $numeroCaratteriDescrizione = strlen($contenuto["metaDescrizione"]);
        if($numeroCaratteriDescrizione==0) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è assente, inseriscila per migliorare l'indicizzazione di questo contenuto.</p>";
        }
        else if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 40) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è troppo corta, solo $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160.</p>";
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriDescrizione > 40 && $numeroCaratteriDescrizione < 160) {
            $punteggioSeo += 2;
        }
        else { //descrizione troppo lunga
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è troppo lunga, $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160 caratteri.</p>";
        }

        //analisi sottotitolo, solo per gli articoli
        $numeroCaratteriSottotitolo = strlen($contenuto["descrizione"]);
        if($numeroCaratteriSottotitolo==0 && $contenuto["tipo"]=="articolo") {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>sottotitolo</strong> è assente, inseriscilo per migliorare l'indicizzazione di questo contenuto.</p>";
            $punteggioSeo -= 1;
        }
        else if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 40  && $contenuto["tipo"]=="articolo") {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>sottotitolo</strong> è troppo corto, solo $numeroCaratteriSottotitolo caratteri. La dimensione ottimale è tra i 100 e i 200 caratteri.</p>";
        }
        else if($numeroCaratteriSottotitolo > 40 && $numeroCaratteriSottotitolo < 200 && $contenuto["tipo"]=="articolo") {
            $punteggioSeo += 1;
        }
        else if( $numeroCaratteriSottotitolo > 200 && $contenuto["tipo"]=="articolo") { //sottotitolo troppo lunga
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>sottottitolo</strong> è troppo lungo, $numeroCaratteriSottotitolo caratteri.  La dimensione ottimale è tra i 100 e i 200 caratteri.</p>";
        }
        
        //analisi testo
        $testoArticolo = filter_var($contenuto["testo"],FILTER_SANITIZE_STRING); // testo senza tag html
        $numeroCaratteriTesto = strlen($testoArticolo);
        if($numeroCaratteriTesto > 0 && $numeroCaratteriTesto < 700) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è troppo corto, solo $numeroCaratteriTesto caratteri. Le dimensioni minime sono di almeno 500 caratteri, quelle ottimali oltre i 1000 caratteri.</p>";
        }
        else if ($numeroCaratteriTesto >700 && $numeroCaratteriTesto < 1500) {
            $punteggioSeo += 1;
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è un po' corto, $numeroCaratteriTesto caratteri. Le dimensioni ottimali sono di almeno 1000 caratteri.</p>";
        }
        else if ($numeroCaratteriTesto > 1500) {
            $punteggioSeo += 2;
        }
        else { //se non c'è testo
            $punteggioSeo += 0;
        }

        ////controllo presenza tag h3, h4 e gli altri tag h
        if(strpos($contenuto["testo"],"<h1>")>0 && $contenuto["tipo"] != "pagina") { // controllo presenza tag h1 (solo per articoli e gallerie, perché in questi tipi di contenuti il link viene posto sul sito)
            $punteggioSeo -= 1;
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Nel <strong>testo</strong> hai inserito un tag h1, che è già usato per il titolo. È raccomandato di inserire un solo h1 per pagina, utilizza i tag h3, h4, h5 o h6 per evidenziare i contenuti nel testo.</p>";
        }
        else if($numeroCaratteriTesto>1500 && (strpos($contenuto["testo"],"<h3>")>0 || strpos($contenuto["testo"],"<h4>")>0 || strpos($contenuto["testo"],"<h5>")>0 || strpos($contenuto["testo"],"<h6>")>0)) {
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriTesto>1500) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è troppo compatto, crea più paragrafi e inserisci un sottotitolo usando i tag h3, h4, h5 o h6.</p>";
        }
        
        //analisi presenza immagini
        $numeroImmagini = 0;
        if ($contenuto["foto"] != "") {
            $numeroImmagini ++;
        }
        $numeroImmagini += substr_count($contenuto["testo"],"<img");
        if($numeroImmagini>0) {
            $punteggioSeo += 1;
        }
        else {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> <strong>Non ci sono immagini</strong> in questo contenuto, inseriscine almeno una.</p>";
        }
        $analisiSeo["suggerimenti"] = $suggerimenti;
        
        //assegnazione valutazione
        $analisiSeo["punteggioSeo"] = $punteggioSeo;
        if($punteggioSeo > 5) {
            $analisiSeo["esito"] = $seoPositivo;
            $analisiSeo["esitoTesto"] = $seoPositivoTesto;
        }
        else if($punteggioSeo == 3 || $punteggioSeo == 4 || $punteggioSeo == 5) {
            $analisiSeo["esito"] = $seoDiscreto;
            $analisiSeo["esitoTesto"] = $seoDiscretoTesto;
        }

        return $analisiSeo;
    }
    
    /*
     * aggiorna l'analisi SEO di un contenuto, viene invocato solo nella pagina
     * contenuti/creaContenuto.php dopo un aggiornamento o dopo la creazione di
     * un nuovo elemento
     * 
     * Questa funzione è stata ricavata dalla funzione eseguiAnalisiSeo, rimuovendo
     * la parte che mostrava a video i suggerimenti e sostituendo il return con la
     * query di aggiornamento
     */
    function aggiornaAnalisiSeo($geecomDb, $idContenuto) {
        $contenuto = $geecomDb->leggiSingolaRiga("geecB_contenuti",$idContenuto);
        
        $seoPositivoTesto = "buona";
        $seoDiscretoTesto = "discreta";
        $seoNegativoTesto = "scadente";
        $punteggioSeo = 0;

        //inizializzazione array che contiene i risultati
        $analisiSeo = array();
        $analisiSeo["esitoTesto"] = $seoNegativoTesto;
                
        //analisi titolo
        $numeroCaratteriTitolo = strlen($contenuto["titolo"]);
        if ($numeroCaratteriTitolo > 20 && $numeroCaratteriTitolo < 50) {
            $punteggioSeo += 1;
        }
                
        //analisi meta descrizione
        $numeroCaratteriDescrizione = strlen($contenuto["metaDescrizione"]);
        if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 40) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è troppo corta, solo $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160.</p>";
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriDescrizione > 40 && $numeroCaratteriDescrizione < 160) {
            $punteggioSeo += 2;
        }

        //analisi sottotitolo, solo per gli articoli
        $numeroCaratteriSottotitolo = strlen($contenuto["descrizione"]);
        if($numeroCaratteriSottotitolo==0 && $contenuto["tipo"]=="articolo") {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>sottotitolo</strong> è assente, inseriscilo per migliorare l'indicizzazione di questo contenuto.</p>";
            $punteggioSeo -= 1;
        }
        else if($numeroCaratteriDescrizione > 40 && $numeroCaratteriDescrizione < 200 && $contenuto["tipo"]=="articolo") {
            $punteggioSeo += 1;
        }
        
        //analisi testo
        $testoArticolo = filter_var($contenuto["testo"],FILTER_SANITIZE_STRING); // testo senza tag html
        $numeroCaratteriTesto = strlen($testoArticolo);
        if ($numeroCaratteriTesto >700 && $numeroCaratteriTesto < 1500) {
            $punteggioSeo += 1;
        }
        else if ($numeroCaratteriTesto > 1500) {
            $punteggioSeo += 2;
        }

        ////controllo presenza tag h3, h4 e gli altri tag h
        if(strpos($contenuto["testo"],"<h1>")>0 && $contenuto["tipo"] != "pagina") { // controllo presenza tag h1 (solo per articoli e gallerie, perché in questi tipi di contenuti il link viene posto sul sito)
            $punteggioSeo -= 1;
        }
        else if($numeroCaratteriTesto>1500 && (strpos($contenuto["testo"],"<h3>")>0 || strpos($contenuto["testo"],"<h4>")>0 || strpos($contenuto["testo"],"<h5>")>0 || strpos($contenuto["testo"],"<h6>")>0)) {
            $punteggioSeo += 1;
        }
        
        //analisi presenza immagini
        $numeroImmagini = 0;
        if ($contenuto["foto"] != "") {
            $numeroImmagini ++;
        }
        $numeroImmagini += substr_count($contenuto["testo"],"<img");
        if($numeroImmagini>0) {
            $punteggioSeo += 1;
        }
        
        //assegnazione valutazione
        if($punteggioSeo > 5) {
            $analisiSeo["esitoTesto"] = $seoPositivoTesto;
        }
        else if($punteggioSeo == 3 || $punteggioSeo == 4 || $punteggioSeo == 5) {
            $analisiSeo["esitoTesto"] = $seoDiscretoTesto;
        }
        
        $queryAggiornamentoPunteggioSeo = "UPDATE geecB_contenuti SET punteggioSeo='{$analisiSeo["esitoTesto"]}' WHERE id={$contenuto["id"]}";
        $geecomDb->eseguiQueryScrittura($queryAggiornamentoPunteggioSeo);
    }
    
    function eseguiAnalisiSeoCategoria($categoria) {
        //variabili che memorizzano l'indicatore per la seo
        $seoPositivo = "<span id=valoreSeo class=\"label label-success\">buona</span>";
        $seoDiscreto = "<span id=valoreSeo class=\"label label-warning\">discreta</span>";
        $seoNegativo = "<span id=valoreSeo class=\"label label-danger\">scadente</span>";
        
        $seoPositivoTesto = "buona";
        $seoDiscretoTesto = "discreta";
        $seoNegativoTesto = "scadente";
        $punteggioSeo = 0;

        //inizializzazione array che contiene i risultati
        $analisiSeo = array();
        $analisiSeo["esito"] = $seoNegativo;
        $analisiSeo["esitoTesto"] = $seoNegativoTesto;
        
        $suggerimenti = array();
        
        //analisi titolo
        $numeroCaratteriTitolo = strlen($categoria["titoloPagina"]);
        if($numeroCaratteriTitolo < 20) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>titolo</strong> è troppo corto, solo $numeroCaratteriTitolo caratteri. Il dato ottimale è tra i 50 e i 70 caratteri.</p>";
        }
        else if ($numeroCaratteriTitolo > 20 && $numeroCaratteriTitolo < 50) {
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriTitolo>70) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>titolo</strong> è troppo lungo, $numeroCaratteriTitolo caratteri. Il dato ottimale è tra i 50 e i 70 caratteri.</p>";
        }
        
        //analisi meta descrizione
        $numeroCaratteriDescrizione = strlen($categoria["metaDescrizione"]);
        if($numeroCaratteriDescrizione==0) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è assente, inseriscila per migliorare l'indicizzazione di questo contenuto.</p>";
        }
        else if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 40) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è troppo corta, solo $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160.</p>";
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriDescrizione > 40 && $numeroCaratteriDescrizione < 160) {
            $punteggioSeo += 2;
        }
        else { //descrizione troppo lunga
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>descrizione</strong> è troppo lunga, $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160 caratteri.</p>";
        }

        $analisiSeo["suggerimenti"] = $suggerimenti;
        
        //assegnazione valutazione
        $analisiSeo["punteggioSeo"] = $punteggioSeo;
        if($punteggioSeo >= 3) {
            $analisiSeo["esito"] = $seoPositivo;
            $analisiSeo["esitoTesto"] = $seoPositivoTesto;
        }
        else if($punteggioSeo == 2) {
            $analisiSeo["esito"] = $seoDiscreto;
            $analisiSeo["esitoTesto"] = $seoDiscretoTesto;
        }

        return $analisiSeo;
    }
    
    function confrontoMediaPunteggio($punteggioSito) {
        $mediaPunteggi = 47;
        if($punteggioSito>47) {
            echo"Sei <strong>sopra la media </strong>";
        }
        else if($punteggioSito==$mediaPunteggi) {
            echo"Sei <strong>nella media </strong>";
        }
        else if($punteggioSito+10>=$mediaPunteggi){
            echo"Sei <strong>di poco sotto media </strong>";
        }
        else {
            echo"Sei <strong>sotto la media </strong>";
        }
    }

    //funzione che si occupa di stampare logo (o semplice nome) e slogan del sito
    //viene usata per creare il div barraSuperiore e barraMenu
    function stampaLogo($logo,$slogan) {	
        if($logo!="") { //se il campo logo costanti sito non è vuoto viene mostrato
                echo"<a class=\"navbar-brand\" href=\"index.php\">{$logo}</a>";
        }

        if($slogan!="") { //se la costante sloganSito non è vuota viene mostrata
                echo"<div class=\"row col-xs-12 slogan\">{$slogan}</div>";
        }
    }

    /*
     * questa funzione restituisce il link di privacy di default del sito, che è
     * quello che si può impostare nella sezione legge sui cookie delle impostazioni
     */
    function linkPrivacyBase($geecomDb) {
        $leggeCookie = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",1);
        $paginaCondizioni = $geecomDb->leggiSingolaRiga("geecB_contenuti",$leggeCookie["paginaMaggioriInformazioni"]);
        $impostazioni = recuperaImpostazioni($geecomDb);
        $linkPagina = GeneratoreUrl::creaUrlContenuto($paginaCondizioni, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
        return $linkPagina;
    }
    
    /* stampa la versione corrente di geecom cms */
    function stampaVersioneProdotto($db) {
        $query = "SELECT * FROM geec_prodotti WHERE nome LIKE 'Cms'";
        $risQuery = $db->eseguiQueryLettura($query);
        $datiProdotto = $risQuery->fetch_assoc();
        echo($datiProdotto["versione"]);
    }

    /* 
     * funzione per creare voci di menu per collegare gli articoli, pagine e gallerie create 
     * utilizzata da creaContenuto.php
     */
    function creaVoceMenu($geecomDb,$contenuto, $impostazioni, $idMenu, $tipo="link", $vocePadre=0, $icona="", $immagine="") {
        $link = GeneratoreUrl::creaUrlContenuto($contenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);

        $queryNumeroVocimenu="SELECT * FROM geecB_vociMenu WHERE idMenu=$idMenu ORDER BY posizione DESC LIMIT 1";		
        $result = $geecomDb->eseguiQueryLettura($queryNumeroVocimenu);
        $riga = $result->fetch_assoc();
        $posizione = $riga['posizione'] + 1;

        //viene creata una voce di menu, il campo tipo viene settato a link perché si tratta di una pagina
        $queryInserimentoVocemenu="INSERT INTO geecB_vociMenu VALUES(NULL,$idMenu,{$contenuto["id"]},'$vocePadre','no','','{$contenuto["titolo"]}','$icona','$immagine','$tipo','$link','$posizione');";
        $geecomDb->eseguiQueryScrittura($queryInserimentoVocemenu);
    }

    // funzione usata dai componenti per creare i link degli elementi
    // usata ad esempio nel file colonneInEvidenza/creaColonneInEvidenza
    function costruisciLink($articolo) {
        $link = 'articolo.php?id='.$articolo['id'].'&alias='.$articolo['alias'];
        return $link;
    }

    // funzione per incrementare il numero di visite globale e giornaliero
    function incrementaConteggioVisite($db, $dataOggi) {
        $datiVisite = $db->leggiSingolaRiga("geecB_statistiche",1);

        if($dataOggi != $datiVisite["dataCorrente"]) {
            $queryAggiornamentoVisite = "UPDATE geecB_statistiche SET visiteGiornaliere=1, dataCorrente='$dataOggi' WHERE id=1";
            
            // creo una nuova occorrenza i dati del giorno precedente nella tabella delle visite
            $queryInserimentoVocemenu="INSERT INTO geecB_visualizzazioniGiornaliere VALUES(NULL,{$datiVisite["visiteGiornaliere"]},'{$datiVisite["dataCorrente"]}');";
            $db->eseguiQueryScrittura($queryInserimentoVocemenu);
        }
        else {
            $queryAggiornamentoVisite = "UPDATE geecB_statistiche SET visiteGiornaliere=visiteGiornaliere+1 WHERE id=1";
        }
        $db->eseguiQueryScrittura($queryAggiornamentoVisite);
    }

    /*
     * Questa funzione serve per aggiornare tutte le voci di menu che puntano
     * al contenuto passato in input
     */
    function aggiornaVociMenuContenuto($db,$contenuto, $ottimizzazioneSeo, $indirizzoSito) {
        $link = GeneratoreUrl::creaUrlContenuto($contenuto, $ottimizzazioneSeo, $indirizzoSito);
        $query = "SELECT * FROM geecB_vociMenu WHERE idContenuto={$contenuto["id"]}";
        $ris = $db->eseguiQueryLettura($query);
        while($voceMenu = $ris->fetch_assoc()) {
            $queryAggiornamento = "UPDATE geecB_vociMenu SET link='$link' WHERE id = {$voceMenu["id"]}";
            $db->eseguiQueryScrittura($queryAggiornamento);
        }
    }
    
    /*
     * questa funzione viene usata da creaContenuto.php e duplicaContenuto.php
     * e da duplicaProdotto.php quando è installato il componente e-commerce. 
     * 
     * Il parametro tabella è impostato di default a geecB_contenuti, quando è usata
     * per un'altra tabella va specificata
     * 
     * Analogamente il campo colonnaDaControllare è impostato a titolo, che è il campo
     * di default da controlalre per la tabella contenuti, può essere sostituito con 
     * quello che serve
     * 
     * si crea un alias  a partire dal titolo del contenuto eliminando spazi e 
     * caratteri speciali controlla se è presente nel database un articol con 
     * quell'alias
     * 
     * una funzione simile è presente anche nella classe Contenuto, in futuro quando
     * tutte le operazioni dei contenuti saranno eliminate questa funzione verrà
     * eliminata
     */
    function generaAlias($geecomDb,$titolo,$tabella = "geecB_contenuti",$colonnaDaControllare="titolo") {
        $alias        = strtolower(ControlloreStringhe::rimuoviCaratteriSpeciali($titolo));
        $titoloEscape = filter_var($titolo,FILTER_SANITIZE_ADD_SLASHES);
        $query ="SELECT * FROM $tabella WHERE $colonnaDaControllare LIKE '$titoloEscape'";
        $ris = $geecomDb->eseguiQueryLettura($query);
        if($ris->num_rows==0) {
            return $alias;
        }
        else {
            $progressivo = $ris->num_rows +1;
            return $alias.$progressivo;
        }
    }
    
    /*
     * Questa funzione calcola un punteggio del sito tenendo in considerazione la
     * percentuale di articoli con seo buona, discreta e scadente. Inoltre prende
     * in considerazione l'https se è attivo o meno, il titolo del sito, la 
     * descrizione del sito, da quanto tempo non vengono pubblicati contenuti e cosi via
     */
    function calcoloStatoSito($impostazioni, $geecomDb) {
        
        $articoliSeoScadente = $geecomDb->contaRigheTabella("geecB_contenuti", array("punteggioSEO"=>"scadente"));
        $articoliSeoDiscreta = $geecomDb->contaRigheTabella("geecB_contenuti", array("punteggioSEO"=>"discreta"));
        $articoliSeoBuona    = $geecomDb->contaRigheTabella("geecB_contenuti", array("punteggioSEO"=>"buona"));
            
        $totaleArticoli = $articoliSeoBuona + $articoliSeoDiscreta + $articoliSeoScadente;
        
        if($articoliSeoBuona>0) {
            $percentualeArticoliSeoBuona = $articoliSeoBuona/$totaleArticoli * 100;
        }
        else {
            $percentualeArticoliSeoBuona = 0;
        }
        
        if($articoliSeoDiscreta>0) {        
            $percentualeArticoliSeoDiscreta = $articoliSeoDiscreta/$totaleArticoli * 100;
        }
        else {
            $percentualeArticoliSeoDiscreta = 0;
        }
        
        if($articoliSeoScadente>0) {
            $percentualeArticoliSeoScadente = $articoliSeoScadente/$totaleArticoli * 100;
        }
        else {
            $percentualeArticoliSeoScadente = 0;
        }
        
        $punteggioSito = 100 - $percentualeArticoliSeoScadente - ($percentualeArticoliSeoDiscreta / 2);
        
        if($impostazioni["reindirizzamentoHttps"]=="nessuno") {
            $punteggioSito = $punteggioSito -2;
        }
        
        if(strlen($impostazioni["titoloSito"])<25) {
            $punteggioSito = $punteggioSito -2;
        }
        
        if(strlen($impostazioni["descrizioneSito"])==0) {
            $punteggioSito = $punteggioSito -2;
        }
        else if(strlen($impostazioni["descrizioneSito"])<50) {
            $punteggioSito = $punteggioSito -1;
        }
        
        if($punteggioSito < 0) {
            $punteggioSito = 0;
        }
        
        $numeroPagineSeoScadente = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"pagina","punteggioSeo"=>"scadente"));
        $numeroPagineSeoDiscreta = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"pagina","punteggioSeo"=>"discreta"));
        $numeroPagineSeoBuona    = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"pagina","punteggioSeo"=>"buona"));

        $numeroArticoliSeoScadente = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","punteggioSeo"=>"scadente"));
        $numeroArticoliSeoDiscreta = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","punteggioSeo"=>"discreta"));    
        $numeroArticoliSeoBuona    = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","punteggioSeo"=>"buona"));
        
        // calcolo delle interazioni
        $numeroCommenti    = $geecomDb->contaRigheTabella("geecB_commenti");
        $numeroCommentiUltimaSettimana =  $geecomDb->contaRigheTabella("geecB_commenti");
        $numeroEmailInviate = $geecomDb->sommaValoriColonna("contatoreInvii","geec_form");
        $numeroClickInvitoAzione = $geecomDb->sommaValoriColonna("numeroClick","geec_invitiAzione");
        $numeroClickSlider = $geecomDb->sommaValoriColonna("numeroClick","geec_slide");
        $numeroClickBanner = $geecomDb->sommaValoriColonna("numeroClickTotali","geec_campagneBanner");
        $numeroClickTabellePrezzi = $geecomDb->sommaValoriColonna("numeroClick","geec_colonneTabellaPrezzi");
        
        // calcolo dei giorni dall'ultimo contenuto pubblicato
        $queryUltimoArticolo = "SELECT * FROM geecB_contenuti ORDER BY id DESC LIMIT 1";
        $risQueryUltimoArticolo  = $geecomDb->eseguiQueryLettura($queryUltimoArticolo);
        $ultimoArticolo =  $risQueryUltimoArticolo->fetch_assoc();
        $intervallo = date_diff(date_create(date("Y-m-d")), date_create($ultimoArticolo["dataCreazione"]));
        
        // prepara l'array per restituire le informazioni
        $risultatoAnalisi = array();
        $risultatoAnalisi["percentualeArticoliSeoScadente"] = $percentualeArticoliSeoScadente;
        $risultatoAnalisi["percentualeArticoliSeoDiscreta"] = $percentualeArticoliSeoDiscreta; 
        $risultatoAnalisi["percentualeArticoliSeoBuona"]    = $percentualeArticoliSeoBuona; 
        $risultatoAnalisi["punteggioSito"] = $punteggioSito;
        $risultatoAnalisi["numeroPagineSeoScadente"] = $numeroPagineSeoScadente;
        $risultatoAnalisi["numeroPagineSeoDiscreta"] = $numeroPagineSeoDiscreta;
        $risultatoAnalisi["numeroPagineSeoBuona"] = $numeroPagineSeoBuona;
        $risultatoAnalisi["numeroArticoliSeoScadente"] = $numeroArticoliSeoScadente;
        $risultatoAnalisi["numeroArticoliSeoDiscreta"] = $numeroArticoliSeoDiscreta;
        $risultatoAnalisi["numeroArticoliSeoBuona"] = $numeroArticoliSeoBuona;
        $risultatoAnalisi["interazioniTotali"]      = $numeroCommenti + $numeroEmailInviate + $numeroClickInvitoAzione;
        $risultatoAnalisi["numeroCommenti"] = $numeroCommenti;
        $risultatoAnalisi["numeroClickSlider"] = $numeroClickSlider;
        $risultatoAnalisi["numeroClickBanner"] = $numeroClickBanner;
        $risultatoAnalisi["numeroClickTabellePrezzi"] = $numeroClickTabellePrezzi;
        $risultatoAnalisi["interazioniUltimaSettimana"] = $numeroCommentiUltimaSettimana;
        $risultatoAnalisi["numeroEmailInviate"] = $numeroEmailInviate;
        $risultatoAnalisi["numeroClickInvitoAzione"] = $numeroClickInvitoAzione;
        $giorniDallultimaPubblicazione = ($intervallo->format("%m") * 30) +$intervallo->format("%d");
        $risultatoAnalisi["giorniDallultimaPubblicazione"] = $giorniDallultimaPubblicazione;
        
        if($punteggioSito>=75) {
            $risultatoAnalisi["classeBoxUtilizzo"] = "success";
            $risultatoAnalisi["icona"] = "far fa-smile";
        }
        else if($punteggioSito<75 && $punteggioSito>35){
            $risultatoAnalisi["classeBoxUtilizzo"] = "warning";
            $risultatoAnalisi["icona"] = "far fa-meh";
        }
        else {
            $risultatoAnalisi["classeBoxUtilizzo"] = "danger";
            $risultatoAnalisi["icona"] = "far fa-frown";
        }
        return $risultatoAnalisi;
    }
    
    /*
     * questa funzione viene utilizzata per stampare un testo
     * motivazionale per l'utente
     */
    function stampaTestoMotivazionale($numero) {
        if($numero<10) {
            echo "<strong class=\"text-danger\"><br>Dobbiamo migliorare!</strong>";
        }
        else if($numero<10 && $numero<100) {
            echo "<strong class=\"text-warning\"><br>Possiamo fare di meglio!</strong>";
        }
        else if($numero<100) {
            echo "<strong class=\"text-success\"><br>Ottimo!</strong>";
        }
    }
    
    /*
     * questa funzione viene utilizzata per stampare un testo
     * motivazionale per l'utente
     */
    function stampaIconaMotivazionale($numero) {
        if(!is_numeric($numero)) {
            echo "fa fa-meh-o fa-2x text-muted";
        }
        else if($numero<10) {
            echo "fa fa-frown-o fa-2x text-danger";
        }
        else if($numero<10 && $numero<100) {
            echo "fa fa-meh-o fa-2x text-warning";
        }
        else if($numero<100) {
            echo "fa fa-smile-o fa-2x text-success";
        }
    }
    
    /*
     * questa funzione serve per controllare la presenza dell'ip nell'array dato.
     * Nell'array dato gli ip possono avere una lunghezza variabile, perché ad esempio
     * si vuole abilitare o bannare una famiglia di ip:
     * 
     * 151.23.123.*  -> indirizzo ip parziale (esempio una rete domestica)
     * 12.213.*      -> indirizzo ip parziale (mette solo i primi due campi, per bannare ad esempio gli ip di un determinato operatore telefonico)
     * 23.1.12.21    -> indirizzo ip completo
     * 
     */
    
    function controlloIpArray($ip,$arrayIp) {
        $trovato = false;
        foreach($arrayIp as $singoloIp) {
            $ipNormalizzato = str_replace("*","",$singoloIp);
            if($ipNormalizzato=="" || strpos($ip,$ipNormalizzato)<0) {
                $trovato = false;
            }
            else {
                $trovato = true;
            }
        }
        return $trovato;
    }
    
    /*
     * Questa funzione serve per stampare le thumbnail delle immagini all'itnerno di 
     * risorse -> immagini articoli, immagini pagine ecc
     */
    function stampaThumbnailGestioneImmagine($percorsoBase,$idDiv,$img) {
        echo"<div class=\"col-xs-12 col-sm-6 col-md-4 col-lg-3 thumbnail box-vertical\" id=\"$idDiv\">
            <div class=\"row row-negative-margin noMarginBottom\">
                <div class=\"col-xs-10\">
                    <h5 class=\"noMargin\"><strong>$img</strong></h5>
                    <h6>$percorsoBase/$img</h6>
                </div>
                <div class=\"col-xs-2\">
                    <button class=\"btn btn-danger btn-sm btn-block\" onclick=\"apriPopupEliminaImmagine('$idDiv','../$percorsoBase/$img')\"><i class=\"fa fa-trash\"></i></button>
                </div>
            </div>
            <img class=img-responsive src=\"../$percorsoBase/$img\">
        </div>";
    }
    
   /*
    * funzione cre restituisce le impostazioni generali della piattaforma
    * è chiamata da tutte le pagine di front end e da index.php di amministrazione
    * essendo anche la prima funzione ad essere chiamata in tutte le pagine di frontend,
    * 
    */
    function recuperaImpostazioni($geecomDb) {
        $queryControlloInstallazioneEffettuata = "SHOW tables";
        $risNumeroTabelle = $geecomDb->eseguiQueryLettura($queryControlloInstallazioneEffettuata);
        
        if($risNumeroTabelle->num_rows>0) {              
            return $geecomDb->leggiSingolaRiga("geecB_impostazioni", 1);
        }
        else {
            header("Location: installazione");
            exit();
        }
    }
    
   /*
    * funzione cre restituisce la configurazione attiva nel momento in cui viene chiamata
    * è chiamata da tutte le pagine di front end e da varie pagine nell'area amministrativa (es creaContenuto.php)
    */
    function recuperaConfigurazioneColori($geecomDb) {
        return $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto","si","selezionataCms");
    }
    
    /*
     * Crea il link che rimanda lla pagina che modifica il componente specificomodificare un componente 
     */
    function creaLinkModifica($componente, $linkBaseAreaAmministrativaCMS) {
        if($componente["nome"]=="Inviti all'azione") {
            return "$linkBaseAreaAmministrativaCMS/componenti/invitoAzione/creaInvitoAzione.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Articoli dal blog") {
            return "$linkBaseAreaAmministrativaCMS/componenti/articoliDalBlog/creaArticoliDalBlog.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Colonne in evidenza") {
            return "$linkBaseAreaAmministrativaCMS/componenti/colonneInEvidenza/creaColonneInEvidenza.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Risorse") {
            return "$linkBaseAreaAmministrativaCMS/componenti/visualizzatoreRisorse/creaVisualizzatoreRisorse.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Confronto immagini") {
            return "$linkBaseAreaAmministrativaCMS/componenti/confrontoImmagini/creaSezione.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Visualizzatore galleria") {
            return "$linkBaseAreaAmministrativaCMS/componenti/visualizzatoreGalleria/creaVisualizzatoreGalleria.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Prodotti dal negozio") {// nel caso sia installato il componente ecommerce
            return "$linkBaseAreaAmministrativaCMS/componenti/prodottiDalNegozio/creaProdottiDalNegozio.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Riga annunci") { // nel caso sia installato il componente annunci
            return "$linkBaseAreaAmministrativaCMS/componenti/annunci/creaRiga.php?id={$componente["idElemento"]}";
        }
        else if($componente["tipo"]=="pagine"){
            $nomeSenzaSpazi = str_replace(" ", "",ucwords($componente["nome"]));
            $primoCarattere = substr($nomeSenzaSpazi, 0,1);
            $primoCarattereMinuscolo = strtolower($primoCarattere);
            $cartellaComponente = $primoCarattereMinuscolo.substr($nomeSenzaSpazi, 1, strlen($nomeSenzaSpazi)-1);
            return "$linkBaseAreaAmministrativaCMS/componenti/$cartellaComponente/index.php";
        }
        else {
            $nomeSenzaSpazi = str_replace(" ", "",ucwords($componente["nome"]));
            $primoCarattere = substr($nomeSenzaSpazi, 0,1);
            $primoCarattereMinuscolo = strtolower($primoCarattere);
            $arrayParole = explode(" ", $componente["nome"]);
            $cartellaComponente = $primoCarattereMinuscolo.substr($nomeSenzaSpazi, 1, strlen($nomeSenzaSpazi)-1);
            return "$linkBaseAreaAmministrativaCMS/componenti/$cartellaComponente/crea{$arrayParole[0]}.php?id={$componente["idElemento"]}";
        }
    }
    
    /*
     * Funzione utilizzata per eliminare tutte le occorrenze di un componente. È presente nei metodi elimina
     * di tutte le classi che gestiscono i componenti. Va ad eliminare ogni occorrenza della tabella geecB_composizionePagine
     * dove è presente il componente di quel tipo con quell'occorrenza
     * 
     * $geecomDb     -> il database su cui effettuare le operazioni
     * $idOccorrenza -> l'id dell'occorrenza del componente che si vuole eliminare
     * $idComponente -> l'id del componente nella tabella geecB_componenti
     */
    function eliminaOccorrenzeComponente($geecomDb,$idOccorrenza,$idComponente) {
        $queryEliminaCercaOccorrenzeComposizionePagine = "SELECT * FROM geecB_composizionePagine WHERE idElemento = $idOccorrenza AND idComponente = $idComponente";
        $risOccorrenze = $geecomDb->eseguiQueryLettura($queryEliminaCercaOccorrenzeComposizionePagine);
        while($occorrenza = $risOccorrenze->fetch_assoc()) {
            if($occorrenza["tipoElemento"]=="contenutoSezione") {
                $queryAggiornamentoSezioniMultiple = array();
                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)] = "UPDATE geec_sezioniADueColonne SET idComponenteSezione1 = 0 WHERE idComponenteSezione1={$occorrenza["id"]}";
                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniADueColonne SET idComponenteSezione2 = 0 WHERE idComponenteSezione2={$occorrenza["id"]}";

                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniATreColonne SET idComponenteSezione1 = 0 WHERE idComponenteSezione1={$occorrenza["id"]}";
                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniATreColonne SET idComponenteSezione2 = 0 WHERE idComponenteSezione2={$occorrenza["id"]}";
                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniATreColonne SET idComponenteSezione3 = 0 WHERE idComponenteSezione3={$occorrenza["id"]}";

                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniAQuattroColonne SET idComponenteSezione1 = 0 WHERE idComponenteSezione1={$occorrenza["id"]}";
                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniAQuattroColonne SET idComponenteSezione2 = 0 WHERE idComponenteSezione2={$occorrenza["id"]}";
                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniAQuattroColonne SET idComponenteSezione3 = 0 WHERE idComponenteSezione3={$occorrenza["id"]}";
                $queryAggiornamentoSezioniMultiple[count($queryAggiornamentoSezioniMultiple)]  = "UPDATE geec_sezioniAQuattroColonne SET idComponenteSezione4 = 0 WHERE idComponenteSezione4={$occorrenza["id"]}";                    

                $geecomDb->eseguiInsiemeDiQuery($queryAggiornamentoSezioniMultiple);
            }
            else {                
                $geecomDb->eseguiQueryCancellazione("geecB_composizionePagine",$occorrenza["id"]);
            }
        }
    }
    
    /*
     * questa funzione viene usata nei rami if che richiedono un controllo
     * se si è amministratori, altrimenti chiunque potrebbe aggiorare le tabelle
     */
    function controlloAccessoAdmin($prefisso = "../") {
        if(!isset($_SESSION["geecomAdmin_email"])) {
            header("Location: ".$prefisso."../index.php");
            exit();
        }
    }
    
    /*
     * questa funzione viene usata per recuperare gli ID delle sottocategorie
     * se si è amministratori, altrimenti chiunque potrebbe aggiorare le tabelle
     */
    function recuperaIdSottoCategorie($geecomDb,$tipo,$idCategoria) {
        $arrayCategorie = array();
        $querySottoCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre='$idCategoria'";
        $risSottoCategoria   = $geecomDb->eseguiQueryLettura($querySottoCategoria);

        while($sottoCategoria=$risSottoCategoria->fetch_assoc()) {
            $arrayCategorie[count($arrayCategorie)] = $sottoCategoria["id"];

            $querySottoCategorie = "SELECT * FROM geec_categorie WHERE categoriaMadre='{$sottoCategoria["id"]}'";
            $risSottoCategoriaDellaSottocategoria = $geecomDb->eseguiQueryLettura($querySottoCategorie);
            while($sottoCategoriaDellaSottocategoria = $risSottoCategoriaDellaSottocategoria->fetch_assoc()) {
                $arrayCategorie[count($arrayCategorie)] = $sottoCategoriaDellaSottocategoria["id"];
            }
        }
        
        return $arrayCategorie;
    }
    
    /*
     * questa funzione viene usata per recuperare la home page in index.php
     */
    function recuperaHomePage($geecomDb,$impostazioni,$impostazioniLingue) {
        if ($impostazioniLingue["linguaPrincipale"]=="italiano") {            
            return $geecomDb->leggiSingolaRiga("geecB_contenuti", $impostazioni["homePage"]);
        }
        else if ($impostazioniLingue["linguaPrincipale"]=="inglese") {            
            return $geecomDb->leggiSingolaRiga("geecB_contenuti", $impostazioni["homePageEn"]);
        }
        else if ($impostazioniLingue["linguaPrincipale"]=="francese") {            
            return $geecomDb->leggiSingolaRiga("geecB_contenuti", $impostazioni["homePageFr"]);
        }
        else if ($impostazioniLingue["linguaPrincipale"]=="spagnolo") {            
            return $geecomDb->leggiSingolaRiga("geecB_contenuti", $impostazioni["homePageEs"]);
        }
        else if ($impostazioniLingue["linguaPrincipale"]=="tedesco") {            
            return $geecomDb->leggiSingolaRiga("geecB_contenuti", $impostazioni["homePageDe"]);
        }
    }
